// *****************************************************************
// -----------------------------------------------------------------
// Translation.h - Die Deklaratation der Translation-Funktionen
// -----------------------------------------------------------------
// *****************************************************************

// *****************************************************************
// Mehrfach-Include-Schutz
// *****************************************************************

#ifndef INC_TRANSLATION_H
#define INC_TRANSLATION_H

// *****************************************************************
// Irgendeine Zahl, die sonst nicht verwendet wird (Hack, ich weiss...)
// *****************************************************************

#define SWITCH_COMMAND_ID 19987
#define STD_INI_SECTION _T("Language")
#define STD_INI_KEY _T("LastTraFile")

// *****************************************************************
// Die Flags einer Sprachdatei
// *****************************************************************

#define FLAG_STANDARD	0x00000001
#define FLAG_AUTOMATIC	0x00000002

// *****************************************************************
// Die Flags der Fenster-Laufzeit-bersetzung
// *****************************************************************

#define WINDOWSWITCH_FLAG_PROPPAGE 1
#define WINDOWSWITCH_FLAG_PROPPAGE_TITLEDLG 2


// *****************************************************************
// Dieser Struct beschreibt die Parameter einer Translation-Datei
// (sollte .tra-Datei sein)
// *****************************************************************

typedef struct
{
	CString szPrg;
	CString szVer;
	CString szName;
	CString szComment;
	CString szFilePath;
	DWORD dwFlags;
	DWORD dwExFlags;
}
TRANSLATEPARAMS;

// *****************************************************************
// Der Start des Translation-Systems
// - sollte beim Programmstart aufgerufen werden
// szStdFile mu eine Standard-Translation (.tra)-Datei sein
// *****************************************************************

bool StartTranslationSystem(CString szStdFile);


// *****************************************************************
// Der Start des Automatic - Translation-Systems
// - sollte beim Programmstart aufgerufen werden
// szStdFile mu eine Standard-Translation (.tra)-Datei sein
// *****************************************************************

// TEST

bool StartAutomaticTranslationSystem(CString szStdFile,
	CString szRelTraPath = _T(""),
	bool bAutoIniFile = true, bool bSwitchDlgAllowOld = true,
	bool bSwitchDlgShowHelp = true, UINT nIDSwitchDlgHelp = ID_HELP,
	UINT nIDSwitchCommand = SWITCH_COMMAND_ID);

// *****************************************************************
// Das Ende des Translation-Systems
// - sollte am Programmende aufgerufen werden
// *****************************************************************

void EndTranslationSystem();


// *****************************************************************
// Schaltet die Sprache auf szNewFile um
// *****************************************************************

bool SwitchTranslationSystem(CString szNewFile);


// *****************************************************************
// bersetzt einen Dialog
// - sollte vor Sichtbarwerden, z.B. von InitDialog, aufgerufen werden
// *****************************************************************

void DoTranslateDialog(CWnd* pDlg, DWORD dwFlags = NULL);
void DoTranslateDialog(HWND hWnd, DWORD dwFlags = NULL);


// *****************************************************************
// bersetzt ein Fenster - Menu
// - sollte vor oder kurz nach Sichtbarwerden aufgerufen werden
// *****************************************************************

void DoTranslateMenu(CWnd* pWnd);

// *****************************************************************
// bersetzt ein einzelnes Menu (Rechte Maus)
// - sollte kurz vor dem Sichtbarwerden aufgerufen werden
// *****************************************************************

void DoTranslateSingleMenu(CMenu* pMenu);
void DoTranslateSingleMenu(HMENU hMenu);

// *****************************************************************
// bersetzt einen String
// *****************************************************************

bool DoTranslateString(CString& szText);

// *****************************************************************
// Liefert die Parameter der aktuellen Sprache
// *****************************************************************

bool GetTranslateParams(TRANSLATEPARAMS* pParams);

// *****************************************************************
// Liefert das Bitmap der aktuellen Sprache
// *****************************************************************

CBitmap* GetTranslateFlag(CDC* pDC);

// *****************************************************************
// Liefert die Parameter einer Sprache aus Datei
// *****************************************************************

bool GetTranslateFileParams(CString szFile, TRANSLATEPARAMS* pParams);

// *****************************************************************
// Liefert das Bitmap einer Sprache aus Datei
// *****************************************************************

CBitmap* GetTranslateFileFlag(CString szFile, CDC* pDC);

// *****************************************************************
// Diese Funktion macht einen Dialog auf, der das Sprach-Umschalten
// zur Laufzeit erlaubt
// *****************************************************************

// Automatic-Version
void DoAutomaticSwitchDialog();

// Version mit String-bergabe
void DoSwitchDialog(CString szTraPath, bool bAllowOld, 
	bool bHelp, UINT nHelpID,
	CString szTextCaption, 
	CString szTextThisVer, CString szTextOldVer,
	CString szTextOK, CString szTextCancel, CString szTextHelp,
	CString szTextVer,
	CString szTextOldVerWarning, CString szTextSwitchError,
	bool bAllowOnlyAutomatic = false);
	
// Version mit Stringtable-ID-bergabe
void DoSwitchDialog(CString szTraPath, bool bAllowOld, 
	bool bHelp, UINT nHelpID,
	UINT nIDTextCaption, 
	UINT nIDTextThisVer, UINT nIDTextOldVer,
	UINT nIDTextOK, UINT nIDTextCancel, UINT nIDTextHelp,
	UINT nIDTextVer,
	UINT nIDTextOldVerWarning, UINT nIDTextSwitchError,
	bool bAllowOnlyAutomatic = false);

// *****************************************************************
// Ende Mehrfach-Include-Schutz
// *****************************************************************

#endif


